<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('organization_id');
			$table->string('plateNo', 15);
			$table->string('city', 50);
			$table->smallInteger('year');
			$table->string('make', 30);
			$table->string('model', 30);
			$table->string('type', 50);
			$table->string('color', 20);
			$table->string('vin', 50);
			$table->integer('mileage');
			$table->integer('fuel');
			$table->integer('mgp');
			$table->integer('capacity');
			$table->string('stationed', 100);
			$table->string('owner', 50);
			$table->text('image');
			$table->string('lat', 20);
			$table->string('long', 20);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}