<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ivoices', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('requests_items', function(Blueprint $table) {
			$table->foreign('request_id')->references('id')->on('requests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_created_by_foreign');
		});
		Schema::table('requests', function(Blueprint $table) {
			$table->dropForeign('requests_category_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('ivoices', function(Blueprint $table) {
			$table->dropForeign('ivoices_order_id_foreign');
		});
		Schema::table('requests_items', function(Blueprint $table) {
			$table->dropForeign('requests_items_request_id_foreign');
		});
	}
}