<?php

namespace Vanguard;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Brand extends Eloquent {

	protected $table = 'brands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsToMany('Vanguard\User');
	}

	public function requests()
	{
		return $this->hasMany('Vanguard\Request');
	}

}