<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRoomsTable extends Migration {

	public function up()
	{
		Schema::create('rooms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('room_type_id')->unsigned();
			$table->boolean('isAvailable')->default(true);
			$table->tinyInteger('max_adults');
			$table->tinyInteger('max_childs');
			$table->timestamps();
			$table->integer('floor');
			$table->decimal('price', 6,3);
			$table->string('description', 100);
		});
	}

	public function down()
	{
		Schema::drop('rooms');
	}
}