<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'category';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'parent_id');

    public function category()
    {
        return $this->belongsTo('Category', 'parent_id');
    }

    public function categories()
    {
        return $this->hasMany('Category', 'parent_id');
    }

}