<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemPayment extends Model 
{

    protected $table = 'item_payment';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('item_id', 'payment_id');

    public function item()
    {
        return $this->belongsTo('Item', 'item_id');
    }

    public function payment()
    {
        return $this->belongsTo('Payment', 'payment_id');
    }

}