<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemTable extends Migration {

	public function up()
	{
		Schema::create('item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('car_id')->nullable();
			$table->string('car_model_id')->nullable();
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->double('price')->nullable();
			$table->boolean('negotiable')->default(0);
			$table->boolean('expired')->default(0);
			$table->double('latitude')->nullable();
			$table->double('longitude')->nullable();
			$table->boolean('mobile')->default(0);
			$table->boolean('facebook')->default(0);
			$table->boolean('twitter')->default(0);
			$table->boolean('whatsapp')->default(0);
			$table->boolean('website');
			$table->boolean('allow_message')->default(0);
			$table->boolean('delivery')->default(0);
			$table->enum('type', array('sale', 'buy'))->nullable();
			$table->integer('year')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('item');
	}
}