<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CarModel extends Eloquent {

	protected $table = 'car_model';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'car_id');

	public function car()
	{
		return $this->belongsTo('Car', 'car_id');
	}

}