<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ItemPayment extends Eloquent {

	protected $table = 'item_payment';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('item_id', 'payment_id');

	public function item()
	{
		return $this->belongsTo('Item', 'item_id');
	}

	public function payment()
	{
		return $this->belongsTo('Payment', 'payment_id');
	}

}