<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Message extends Eloquent {

	protected $table = 'message';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('conversation_id', 'is_seller', 'message', 'read');

	public function conversation()
	{
		return $this->belongsTo('Conversation', 'conversation_id');
	}

}