<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessageTable extends Migration {

	public function up()
	{
		Schema::create('message', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('conversation_id')->nullable();
			$table->boolean('is_seller')->default(0);
			$table->text('message')->nullable();
			$table->boolean('read')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('message');
	}
}