<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Journey extends Model 
{

    protected $table = 'journeys';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function passengers()
    {
        return $this->hasMany('Passenger');
    }

    public function status()
    {
        return $this->belongsTo('Status');
    }

    public function depart_address()
    {
        return $this->belongsTo('\Addresse');
    }

    public function arrival_address()
    {
        return $this->belongsTo('Addresse');
    }

    public function opinions()
    {
        return $this->hasMany('Opinion');
    }

}