<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Opinion extends Model 
{

    protected $table = 'opinions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function passengerOwner()
    {
        return $this->belongsTo('Passenger');
    }

    public function journey()
    {
        return $this->belongsTo('Journey');
    }

}