<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Passenger extends Model 
{

    protected $table = 'passengers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function journey()
    {
        return $this->belongsTo('Journey');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function status()
    {
        return $this->belongsTo('Status');
    }

    public function receivedOpinion()
    {
        return $this->hasOne('Opinion');
    }

    public function writtedOpinion()
    {
        return $this->hasOne('Opinion');
    }

}