<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('email', 100);
			$table->string('firstname');
			$table->string('lastname');
			$table->string('password');
			$table->boolean('is_verified')->default(0);
			$table->string('verif_code');
			$table->integer('address_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}