<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateJourneysTable extends Migration {

	public function up()
	{
		Schema::create('journeys', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('depart_address_id')->unsigned();
			$table->integer('arrival_address_id')->unsigned();
			$table->integer('status_id')->unsigned();
			$table->datetime('depart_time');
			$table->datetime('arrival_time');
			$table->boolean('is_favorite')->default(0);
			$table->smallInteger('seats_count')->default('0');
			$table->string('description');
			$table->boolean('is_driver')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('journeys');
	}
}