<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOpinionsTable extends Migration {

	public function up()
	{
		Schema::create('opinions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('note');
			$table->string('comment');
			$table->boolean('is_valid')->default(0);
			$table->bigInteger('journey_id')->unsigned();
			$table->bigInteger('passenger_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('writer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('opinions');
	}
}