<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Opinion extends Eloquent {

	protected $table = 'opinions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function passengerOwner()
	{
		return $this->belongsTo('Passenger');
	}

	public function journey()
	{
		return $this->belongsTo('Journey');
	}

}