<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('inspection_docs', function(Blueprint $table) {
			$table->foreign('inspection_report_id')->references('id')->on('inspection_reports')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inspection_doc_downloads', function(Blueprint $table) {
			$table->foreign('inspection_doc_id')->references('id')->on('inspection_docs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inspection_report_summary', function(Blueprint $table) {
			$table->foreign('inspection_report_id')->references('id')->on('inspection_reports')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inspection_comments', function(Blueprint $table) {
			$table->foreign('inspection_report_id')->references('id')->on('inspection_reports')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('inspection_sharing', function(Blueprint $table) {
			$table->foreign('inspection_report_id')->references('id')->on('inspection_reports')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('inspection_docs', function(Blueprint $table) {
			$table->dropForeign('inspection_docs_inspection_report_id_foreign');
		});
		Schema::table('inspection_doc_downloads', function(Blueprint $table) {
			$table->dropForeign('inspection_doc_downloads_inspection_doc_id_foreign');
		});
		Schema::table('inspection_report_summary', function(Blueprint $table) {
			$table->dropForeign('inspection_report_summary_inspection_report_id_foreign');
		});
		Schema::table('inspection_comments', function(Blueprint $table) {
			$table->dropForeign('inspection_comments_inspection_report_id_foreign');
		});
		Schema::table('inspection_sharing', function(Blueprint $table) {
			$table->dropForeign('inspection_sharing_inspection_report_id_foreign');
		});
	}
}