<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model 
{

    protected $table = 'campaigns';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function codes()
    {
        return $this->hasMany('App\Campaign');
    }

    public function stages()
    {
        return $this->hasMany('App\Campaign');
    }

    public function subscribers()
    {
        return $this->hasMany('App\Participant')->withPicot('CampaignSubscriber');
    }

}