<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->boolean('current');
			$table->datetime('start_datetime');
			$table->datetime('end_datetime');
			$table->string('background_desktop', 255);
			$table->string('background_mobile', 255);
			$table->string('share_img', 255);
			$table->string('share_title', 255)->nullable();
			$table->text('share_content')->nullable();
			$table->text('like_content')->nullable();
			$table->integer('like_page_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}