<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignCodesTable extends Migration {

	public function up()
	{
		Schema::create('campaign_codes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('campaign_id')->unsigned();
			$table->integer('campaign_code_parent_id')->unsigned()->nullable();
			$table->string('code', 255)->nullable();
			$table->datetime('start_datetime');
			$table->datetime('end_datetime');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campaign_codes');
	}
}