<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('participants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('campaign_id')->unsigned();
			$table->integer('campaign_code_id')->unsigned();
			$table->integer('fb_user_id')->unsigned()->nullable();
			$table->string('fullname', 255);
			$table->string('email', 255);
			$table->string('phone', 255)->nullable();
			$table->boolean('sky_optin');
			$table->boolean('partner_optin');
			$table->string('likes_pages', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('participants');
	}
}