<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAmenitiesTable extends Migration {

	public function up()
	{
		Schema::create('amenities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('img', 100)->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('amenities');
	}
}