<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesFeaturesTable extends Migration {

	public function up()
	{
		Schema::create('properties_features', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('room_type_id')->unsigned();
			$table->string('name', 100)->index();
			$table->string('img', 100)->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('properties_features');
	}
}