<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesInfosTable extends Migration {

	public function up()
	{
		Schema::create('properties_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->bigInteger('property_type_id')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('properties_infos');
	}
}