<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyCheckinDetailesTable extends Migration {

	public function up()
	{
		Schema::create('property_checkin_detailes', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->time('arrive_after')->nullable();
			$table->time('arrive_before')->nullable();
			$table->time('leave_before')->nullable();
			$table->integer('min_stay')->unsigned();
			$table->integer('max_stay')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_checkin_detailes');
	}
}