<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertiesTable extends Migration {

	public function up()
	{
		Schema::create('properties', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name', 255)->nullable();
			$table->string('description', 1000)->nullable();
			$table->bigInteger('property_type_id')->unsigned();
			$table->bigInteger('room_type_id')->unsigned()->nullable();
			$table->enum('want_guests', array('as_often_as_possible', 'part_time', 'im_not_sure_yet'))->nullable();
			$table->decimal('base_price', 6,2)->nullable();
			$table->decimal('min_price', 6,2)->nullable();
			$table->decimal('max_price', 6,2)->nullable();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->string('mobile_status', 1000)->nullable();
			$table->smallInteger('weekly_discount')->nullable();
			$table->smallInteger('monthly_descount')->nullable();
			$table->enum('status', array('pending', 'verified', 'blocked'))->default('pending');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('hosted_by_host')->unsigned()->default('0');
			$table->tinyInteger('admin_approval')->default('0');
			$table->smallInteger('max_guest')->unsigned()->nullable();
			$table->decimal('cleaning_fee', 6,2)->nullable();
			$table->decimal('service_fee', 6,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('properties');
	}
}