<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyBookingAvailabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('property_booking_availabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->tinyInteger('advance_notice')->unsigned()->nullable();
			$table->boolean('reservation_requests');
			$table->tinyInteger('availability_window', 3)->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_booking_availabilities');
	}
}