<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('thanas', function(Blueprint $table) {
			$table->foreign('district_id')->references('id')->on('districts')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('Zones', function(Blueprint $table) {
			$table->foreign('thana_id')->references('id')->on('thanas')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('Zones')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('thanas', function(Blueprint $table) {
			$table->dropForeign('thanas_district_id_foreign');
		});
		Schema::table('Zones', function(Blueprint $table) {
			$table->dropForeign('Zones_thana_id_foreign');
		});
		Schema::table('vendors', function(Blueprint $table) {
			$table->dropForeign('vendors_zone_id_foreign');
		});
	}
}