<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePalletsTable extends Migration {

	public function up()
	{
		Schema::create('pallets', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('code', 13);
			$table->date('date');
			$table->bigInteger('plan_id')->unsigned();
			$table->integer('number');
			$table->integer('type');
			$table->bigInteger('brand_id')->unsigned();
			$table->bigInteger('lot_id')->unsigned();
			$table->bigInteger('location_id')->unsigned();
			$table->tinyInteger('wip');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('size_id')->unsigned();
			$table->bigInteger('surface_id')->unsigned();
			$table->bigInteger('color_id')->unsigned();
			$table->bigInteger('weight_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('pallets');
	}
}