<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DpmPegawai extends Model 
{

    protected $table = 'dpm_pegawai';
    public $timestamps = true;

    public function dpmSaham()
    {
        return $this->hasMany('App\DpmSaham', 'dpm_id', 'id');
    }

    public function dpmAset()
    {
        return $this->hasMany('App\DpmAset', 'dpm_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo('App\User', 'nip_pegawai', 'nip');
    }

    public function validasiDpm()
    {
        return $this->belongsTo('App\ValidasiDpm', 'validasi_id', 'id');
    }

    public function companyCode()
    {
        return $this->belongsTo('App\CompanyCode', 'company_code', 'company_code');
    }

    public function businessArea()
    {
        return $this->belongsTo('App\BusinessArea', 'business_area', 'business_area');
    }

}