<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function role()
	{
		return $this->belongsToMany('Role');
	}

	public function attempts()
	{
		return $this->hasMany('Login_attempts');
	}

}