<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('plan_id')->unsigned();
			$table->timestamps();
			$table->string('name');
			$table->string('address');
			$table->string('email');
			$table->string('web');
			$table->string('logo');
			$table->string('password');
			$table->string('phone');
			$table->tinyInteger('email_verified');
			$table->datetime('email_verified_at')->nullable();
			$table->string('email_verification_token')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->string('type');
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}