<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('company_id')->unsigned();
			$table->string('full_name');
			$table->string('email');
			$table->string('password');
			$table->string('phone');
			$table->string('address');
			$table->string('photo')->nullable();
			$table->tinyInteger('email_verified')->default('0');
			$table->datetime('email_verified_at')->nullable();
			$table->string('email_verification_token');
			$table->string('designation');
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}