<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Attendees extends Model 
{

    protected $table = 'attendees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'employee_id', 'date', 'type');

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

}