<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EmployeeDeduction extends Model 
{

    protected $table = 'employee_deduction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'type_id', 'employee_id', 'amount', 'calculation_method');

    public function type()
    {
        return $this->belongsTo('EmployeeDeductionType', 'type_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

}