<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transaction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'date', 'account_id', 'type', 'description_en', 'description_ar', 'debit', 'credit', 'balance');

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

}