<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('employee', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->integer('job_description_id')->nullable();
			$table->integer('nationality_id')->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->date('birthdate')->nullable();
			$table->enum('status', array('single', 'married', 'divorced', 'engaged'))->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->string('address_en')->nullable();
			$table->string('address_ar')->nullable();
			$table->string('employee_code')->nullable();
			$table->datetime('join_date')->nullable();
			$table->double('main_salary')->nullable();
			$table->string('civil_id')->nullable();
			$table->string('national_id')->nullable();
			$table->datetime('entrance_date')->nullable();
			$table->string('passport_id')->nullable();
			$table->datetime('residence_at')->nullable();
			$table->datetime('residence_end')->nullable();
			$table->datetime('passport_end_date')->nullable();
			$table->enum('work_status', array('working', 'not_working'))->nullable();
			$table->integer('bank_id')->nullable();
			$table->string('account_number', 300)->nullable();
			$table->string('beneficiary_name', 300)->nullable();
			$table->string('iban', 200)->nullable();
			$table->string('swift')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('employee');
	}
}