<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model 
{

    protected $table = 'account';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'type_id', 'name_en', 'name_ar', 'description_en', 'description_ar', 'balance', 'initial_balance');

    public function type()
    {
        return $this->belongsTo('AccountType', 'type_id');
    }

}