<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustodyData extends Model 
{

    protected $table = 'custody_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_en', 'name_ar', 'category_id');

    public function category()
    {
        return $this->belongsTo('CustodyCategory', 'category_id');
    }

}