<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CustodyMovement extends Model 
{

    protected $table = 'custody_movement';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('custody_id', 'date', 'movement');

    public function custody()
    {
        return $this->belongsTo('Custody', 'custody_id');
    }

}