<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Deduction extends Model 
{

    protected $table = 'deduction';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('account_id', 'country_id', 'mall_id', 'employee_id', 'type_id', 'amount', 'date', 'status', 'notes_en', 'notes_ar');

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function type()
    {
        return $this->belongsTo('DeductionType', 'type_id');
    }

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

}