<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'name_en', 'name_ar', 'job_description_id', 'nationality_id', 'gender', 'birthdate', 'status', 'email', 'phone', 'address_en', 'address_ar', 'employee_code', 'join_date', 'main_salary', 'civil_id', 'national_id', 'entrance_date', 'passport_id', 'residence_at', 'residence_end', 'passport_end_date', 'work_status', 'bank_id', 'account_number', 'beneficiary_name', 'iban', 'swift');

    public function job_description()
    {
        return $this->belongsTo('JobDescription', 'job_description_id');
    }

    public function nationality()
    {
        return $this->belongsTo('Nationality', 'nationality_id');
    }

}