<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payroll extends Model 
{

    protected $table = 'payroll';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'account_id', 'month', 'year', 'employee_number', 'total', 'payment_date', 'description_en', 'description_ar');

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

}