<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PayrollEmployee extends Model 
{

    protected $table = 'payroll_employee';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'employee_id', 'payroll_id', 'main_salary', 'allowances', 'deductions', 'bonus', 'total');

    public function payroll()
    {
        return $this->belongsTo('Payroll', 'payroll_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

}