<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Receipt extends Model 
{

    protected $table = 'receipt';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'employee_id', 'account_id', 'type', 'date', 'amount', 'allocate', 'allocate_id');

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

}