<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vacation extends Model 
{

    protected $table = 'vacation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'mall_id', 'employee_id', 'type_id', 'start_at', 'end_at', 'status', 'application_date', 'amount');

    public function employee()
    {
        return $this->belongsTo('Employee', 'employee_id');
    }

    public function type()
    {
        return $this->belongsTo('VacationType', 'type_id');
    }

}