<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttendeesTable extends Migration {

	public function up()
	{
		Schema::create('attendees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->datetime('date')->nullable();
			$table->enum('type', array('attending', 'leaving'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attendees');
	}
}