<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustodyMovementTable extends Migration {

	public function up()
	{
		Schema::create('custody_movement', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('custody_id')->nullable();
			$table->datetime('date')->nullable();
			$table->enum('movement', array('received', 'delivered'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('custody_movement');
	}
}